/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.scanner.tokenMap;

import com.aptana.editor.php.internal.parser.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.scanner.PHPCodeScanner;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.IPHPTokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHP4TokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHP53TokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHP54TokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHP5TokenMapper;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java_cup.runtime.Symbol;
import org.eclipse.jface.text.rules.IToken;
import org2.eclipse.php.internal.core.PHPVersion;

public class PHPTokenMapperFactory {
    private static PHP4TokenMapper php4TokenMapper;
    private static PHP5TokenMapper php5TokenMapper;
    private static PHP53TokenMapper php53TokenMapper;
    private static PHP54TokenMapper php54TokenMapper;
    private static final Pattern CONSTANT_PATTERN;
    public static Set<String> GLOBALS;
    public static Set<String> SAFER_GLOBALS;
    private static Set<String> ASSIGNMENTS;
    private static Set<String> LOGICAL_OPERATORS;
    private static Set<String> INC_DEC_OPERATORS;
    private static Set<String> ARITHMETIC_OPERATORS;
    private static Set<String> BITWISE_OPERATORS;
    private static Set<String> COMPARISON_OPERATORS;

    static {
        CONSTANT_PATTERN = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
        GLOBALS = new HashSet<String>();
        GLOBALS.add("$_COOKIE");
        GLOBALS.add("$_FILES");
        GLOBALS.add("$_POST");
        GLOBALS.add("$_GET");
        GLOBALS.add("$_REQUEST");
        GLOBALS.add("$PHP_SELF");
        GLOBALS.add("$HTTP_POST_VARS");
        GLOBALS.add("$HTTP_GET_VARS");
        GLOBALS.add("$HTTP_ENV_VARS");
        GLOBALS.add("$HTTP_SERVER_VARS");
        GLOBALS.add("$HTTP_COOKIE_VARS");
        SAFER_GLOBALS = new HashSet<String>();
        SAFER_GLOBALS.add("$GLOBALS");
        SAFER_GLOBALS.add("$_SESSION");
        SAFER_GLOBALS.add("$_SERVER");
        SAFER_GLOBALS.add("$_ENV");
        ASSIGNMENTS = new HashSet<String>();
        ASSIGNMENTS.add("=");
        ASSIGNMENTS.add("|=");
        ASSIGNMENTS.add("&=");
        ASSIGNMENTS.add("^=");
        ASSIGNMENTS.add("%=");
        ASSIGNMENTS.add("/=");
        ASSIGNMENTS.add("*=");
        LOGICAL_OPERATORS = new HashSet<String>();
        LOGICAL_OPERATORS.add("!");
        LOGICAL_OPERATORS.add("&&");
        LOGICAL_OPERATORS.add("||");
        LOGICAL_OPERATORS.add("^");
        LOGICAL_OPERATORS.add("and");
        LOGICAL_OPERATORS.add("or");
        LOGICAL_OPERATORS.add("xor");
        LOGICAL_OPERATORS.add("as");
        LOGICAL_OPERATORS.add("insteadof");
        INC_DEC_OPERATORS = new HashSet<String>();
        INC_DEC_OPERATORS.add("--");
        INC_DEC_OPERATORS.add("++");
        ARITHMETIC_OPERATORS = new HashSet<String>();
        ARITHMETIC_OPERATORS.add("-");
        ARITHMETIC_OPERATORS.add("+");
        ARITHMETIC_OPERATORS.add("*");
        ARITHMETIC_OPERATORS.add("/");
        ARITHMETIC_OPERATORS.add("%");
        BITWISE_OPERATORS = new HashSet<String>();
        BITWISE_OPERATORS.add("<<");
        BITWISE_OPERATORS.add(">>");
        BITWISE_OPERATORS.add("~");
        BITWISE_OPERATORS.add("^");
        BITWISE_OPERATORS.add("&");
        BITWISE_OPERATORS.add("|");
        COMPARISON_OPERATORS = new HashSet<String>();
        COMPARISON_OPERATORS.add("<");
        COMPARISON_OPERATORS.add("==");
        COMPARISON_OPERATORS.add("===");
        COMPARISON_OPERATORS.add("!==");
        COMPARISON_OPERATORS.add("!=");
        COMPARISON_OPERATORS.add("<=");
        COMPARISON_OPERATORS.add(">=");
        COMPARISON_OPERATORS.add("<>");
        COMPARISON_OPERATORS.add(">");
    }

    public static IPHPTokenMapper getMapper(PHPVersion phpVersion) {
        switch (phpVersion) {
            case PHP4: {
                if (php4TokenMapper == null) {
                    php4TokenMapper = new PHP4TokenMapper();
                }
                return php4TokenMapper;
            }
            case PHP5: {
                if (php5TokenMapper == null) {
                    php5TokenMapper = new PHP5TokenMapper();
                }
                return php5TokenMapper;
            }
            case PHP5_3: {
                if (php53TokenMapper == null) {
                    php53TokenMapper = new PHP53TokenMapper();
                }
                return php53TokenMapper;
            }
            case PHP5_4: {
                if (php54TokenMapper == null) {
                    php54TokenMapper = new PHP54TokenMapper();
                }
                return php54TokenMapper;
            }
        }
        throw new IllegalArgumentException("Unknown PHP version " + phpVersion.getAlias());
    }

    public static IToken mapDefaultToken(PHPCodeScanner scanner, Symbol sym) {
        String tokenContent = scanner.getSymbolValue(sym);
        if (";".equals(tokenContent)) {
            return scanner.getToken(PHPTokenType.PUNCTUATION_TERMINATOR.toString());
        }
        if ("(".equals(tokenContent)) {
            return scanner.getToken(PHPTokenType.PUNCTUATION_PARAM_LEFT.toString());
        }
        if (")".equals(tokenContent)) {
            return scanner.getToken(PHPTokenType.PUNCTUATION_PARAM_RIGHT.toString());
        }
        if ("[".equals(tokenContent)) {
            return scanner.getToken(PHPTokenType.PUNCTUATION_LBRACKET.toString());
        }
        if ("]".equals(tokenContent)) {
            return scanner.getToken(PHPTokenType.PUNCTUATION_RBRACKET.toString());
        }
        if (ASSIGNMENTS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_ASSIGN.toString());
        }
        if (LOGICAL_OPERATORS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_LOGICAL.toString());
        }
        if (COMPARISON_OPERATORS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_COMPARISON.toString());
        }
        if (ARITHMETIC_OPERATORS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_ARITHMETIC.toString());
        }
        if (BITWISE_OPERATORS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_BITWISE.toString());
        }
        if (INC_DEC_OPERATORS.contains(tokenContent)) {
            return scanner.getToken(PHPTokenType.KEYWORD_OP_INC_DEC.toString());
        }
        if (CONSTANT_PATTERN.matcher(tokenContent).matches()) {
            return scanner.getToken(PHPTokenType.CONSTANT_OTHER.toString());
        }
        return scanner.getToken("");
    }
}

